export class TimerManager {
    timers;
    intervals;
    constructor() {
        this.timers = new Set();
        this.intervals = new Set();
    }
    setTimeout(callback, delay, ...args) {
        const timer = setTimeout(() => {
            this.timers.delete(timer);
            callback(...args);
        }, delay, ...args);
        this.timers.add(timer);
        return timer;
    }
    setInterval(callback, delay, ...args) {
        const interval = setInterval(callback, delay, ...args);
        this.intervals.add(interval);
        return interval;
    }
    clearTimeout(timer) {
        if (timer) {
            clearTimeout(timer);
            this.timers.delete(timer);
        }
    }
    clearInterval(interval) {
        if (interval) {
            clearInterval(interval);
            this.intervals.delete(interval);
        }
    }
    clearAll() {
        for (const timer of this.timers) {
            clearTimeout(timer);
        }
        for (const interval of this.intervals) {
            clearInterval(interval);
        }
        this.timers.clear();
        this.intervals.clear();
    }
    destroy() {
        this.clearAll();
    }
}
export function createTimerManager() {
    return new TimerManager();
}
//# sourceMappingURL=timerManager.js.map