export const CONSTANTS = {
    FILE_SIZES: {
        MAX_PNG_BYTES: 25 * 1024 * 1024,
        MAX_REF_IMAGE_BYTES: 40 * 1024 * 1024,
        MAX_RECORD_BYTES: 512 * 1024 * 1024
    },
    TIMING: {
        AUTO_LAUNCH_DELAY: 260,
        SCREENSHOT_CAPTURE_RETRY_DELAY: 40,
        MOUSE_DOT_VISIBLE_DURATION: 200,
        MOUSE_DOT_PULSE_DURATION: 250,
        RECORD_TOOLBAR_AUTO_HIDE_DELAY: 3000,
        SETTINGS_WRITE_DELAY: 260,
        HOVER_CHECK_THROTTLE: 16,
        TRAIL_CONFIG_READ_THROTTLE: 200
    },
    DIMENSIONS: {
        MIN_PINNED_SIZE: 24,
        MAX_PINNED_SIZE: 16384,
        MIN_CROP_SIZE: 2,
        MAX_CROP_SIZE: 16384,
        CAPTURE_THUMBNAIL_MAX_DIM: 4096,
        DEFAULT_CAPTURE_WIDTH: 1920,
        DEFAULT_CAPTURE_HEIGHT: 1080
    },
    LIMITS: {
        MAX_CSS_VARS: 240,
        MAX_CSS_VAR_LENGTH: 128,
        MAX_SETTINGS_KEYS: 2000,
        MAX_TRAIL_DOTS: 12,
        DEFAULT_TRAIL_DOTS: 6,
        MAX_DETAILS_LENGTH: 280,
        MAX_DETAILS_LINES: 3
    },
    VALUES: {
        MIN_TRAIL_LERP: 0.05,
        MAX_TRAIL_LERP: 0.95,
        DEFAULT_TRAIL_LERP: 0.35,
        RECORD_FPS_MIN: 1,
        RECORD_FPS_MAX: 60,
        RECORD_FPS_DEFAULT: 12,
        SCALE_FACTOR_MIN: 0.92,
        SCALE_FACTOR_MAX: 1.08
    },
    KEYS: {
        DEBUG_KEYS_MAX: 20
    },
    REGISTRY: {
        WINDOWS_RUN_KEY: 'HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Run',
        WINDOWS_AUTO_LAUNCH_VALUE: 'TT'
    },
    EXTENSIONS: {
        IMAGE: ['png', 'jpg', 'jpeg', 'webp', 'gif', 'bmp'],
        VIDEO: ['mp4', 'webm', 'gif']
    },
    MIME_TYPES: {
        PNG: 'image/png',
        JPEG: 'image/jpeg',
        WEBP: 'image/webp',
        GIF: 'image/gif',
        BMP: 'image/bmp',
        OCTET_STREAM: 'application/octet-stream'
    }
};
export default CONSTANTS;
//# sourceMappingURL=constants.js.map