const http = require('http')
const fs = require('fs')
const path = require('path')

const port = process.env.PORT ? Number(process.env.PORT) : 3000
const root = __dirname

const mime = {
  '.html': 'text/html; charset=utf-8',
  '.css': 'text/css; charset=utf-8',
  '.js': 'application/javascript; charset=utf-8',
  '.png': 'image/png',
  '.jpg': 'image/jpeg',
  '.jpeg': 'image/jpeg',
  '.svg': 'image/svg+xml',
  '.json': 'application/json; charset=utf-8'
}

const server = http.createServer((req, res) => {
  if (req.method !== 'GET' && req.method !== 'HEAD') { res.writeHead(405, { 'Content-Type': 'text/plain; charset=utf-8' }); res.end('Method Not Allowed'); return }

  let pathname = '/'
  try {
    const u = new URL(req.url || '/', `http://${req.headers.host || 'localhost'}`)
    pathname = u.pathname || '/'
  } catch {}

  try { pathname = decodeURIComponent(pathname) } catch {}
  const normalized = path.posix.normalize(pathname)
  const rel = normalized.replace(/^\/+/, '')
  const requested = rel ? rel : 'index.html'
  const abs = path.resolve(root, requested)
  const rootAbs = path.resolve(root)
  if (abs !== rootAbs && !abs.startsWith(rootAbs + path.sep)) { res.writeHead(403, { 'Content-Type': 'text/plain; charset=utf-8' }); res.end('Forbidden'); return }

  let filePath = abs

  fs.stat(filePath, (err, stat) => {
    if (err) { res.writeHead(404, { 'Content-Type': 'text/plain; charset=utf-8' }); res.end('Not Found'); return }
    if (stat.isDirectory()) filePath = path.join(filePath, 'index.html')
    fs.readFile(filePath, (readErr, data) => {
      if (readErr) { res.writeHead(500, { 'Content-Type': 'text/plain; charset=utf-8' }); res.end('Server Error'); return }
      const ext = path.extname(filePath).toLowerCase()
      res.writeHead(200, { 'Content-Type': mime[ext] || 'application/octet-stream' })
      res.end(data)
    })
  })
})

server.listen(port, () => { console.log(`Preview server running at http://localhost:${port}/`) })
