# TT

透明置顶的键鼠可视化工具（Electron）。

## 运行

```bash
npm install
npm run start
```

## 镜像（可选）

如果你需要使用国内镜像来下载 Electron / electron-builder 相关二进制：

```bash
npm run install:mirrors
```

打包脚本 `npm run dist` / `npm run dist:portable` 也会自动带上镜像环境变量。

也可以手动设置环境变量：
- `ELECTRON_MIRROR`
- `ELECTRON_BUILDER_BINARIES_MIRROR`

## 自检

```bash
npm run check
```

自检会验证：
- 关键 JS 文件语法可通过 Node 解析
- `index.html` / `settings.html` 的 CSP 不包含 `script-src 'unsafe-inline'`
- 主进程不包含高风险的 `executeJavaScript(` / `nodeIntegration: true` / `contextIsolation: false`

## 构建

- 打包 zip：

```bash
npm run dist
```

- 可移植 zip（输出到时间戳目录）：

```bash
npm run dist:portable
```

- 原始打包（electron-packager）：

```bash
npm run pack:raw
```

## 目录结构（简要）

- `main.js`：主进程（窗口/托盘/全局键鼠事件/IPC/保存与导出）
- `preload.js`：安全桥（渲染层调用主进程能力的唯一入口）
- `src/renderer/main.js`：Overlay 渲染层
- `src/renderer/settings.js`：设置页渲染层
- `native/geometry`：可选 Rust N-API 模块
